/* jq_imgMapToCanvas.js 2010-12-15→2012-01-23*/
$(function(){
	imgMapToCanvasInit();
	$("area").hover( //図形の形・座標取得→描画・消去　(ここから先thisはarea要素を示す)	
		function(e){//area:hover時
			var id="canvas_"+$(this).parent().attr("name");//hoverになったareaのmapのname属性からidを取得
			var shape=$(this).attr("shape").toLowerCase();//circleまたはpolyまたはrect、IE6は大文字取得なので小文字変換
			var coords=$(this).attr("coords").split(",");//areaのcoords(座標)をカンマ区切りで配列に格納
			for(i in coords){coords[i]=parseInt(coords[i]);}//文字列→数値
                           //areaから色取得(area色情報無しの場合初期値)
			var color=$(this).attr("color");//色取得
			if(!color){color='rgba(255, 100, 0, 0.7)';}//areaに色指定していない場合の初期値
			imgMapToCanvasDraw(id,shape,coords,color);//値をdrawする
		},
		function(e){//area:hover解除時にid指定→クリア
			var id="canvas_"+$(this).parent().attr("name");//hoverになったareaのmapのname属性からidを取得
			imgMapToCanvasClear(id);//値をclearする
		}
	);
});
function imgMapToCanvasInit(){
	$("img.imgMapToCanvas").each(function(){//すべてのimgMapToCanvas設定されたimg要素を処理
		//親(divやliなど)をrelative
		$(this).parent().css("position","relative");//div要素をposition:relativeに設定
		//イメージ属性
		var position=$(this).position();
		var height=$(this).attr("height");//img高さ=canvas高さ
		var width=$(this).attr("width");//img幅=canvas幅
		var src="url("+$(this).attr("src")+")";//img画像名=canvas背景
		var useMap=$(this).attr("usemap").split("#")[1];//usemap属性から#をとる
		var id="canvas_"+useMap;//上記をcanvasのidとする(canvas_***)
		//canvas設置
		var canvas = document.createElement("canvas");//canvas要素生成
		$(canvas).attr({"id":id,"width":width,"height":height});//canvasの幅・高さ設定
		$(this).before(canvas);//img要素の前にcanvasを設置
		if (!jQuery.support.opacity) {//IEの場合
			canvas = G_vmlCanvasManager.initElement(canvas);//IEの場合のcanvas初期化
		}
		//canvasに透明度1,z-indexを背面,positionを設定,背景にimg要素
		$("canvas#"+id)
                  .css({"opacity":"1.0","zIndex":"1","position":"absolute","top":position.top,"left":position.left,"backgroundImage":src});
		//img要素を透明度0.1(うっすらと),z-indexを前面,positionを設定
		$(this)
                  .css({"opacity":"0.1","zIndex":"100","position":"absolute","top":position.top,"left":position.left});
	});
}
function imgMapToCanvasDraw(id,shape,coords,color){
	var canvas = document.getElementById(id);
	if (!canvas || !canvas.getContext) {return false;}
	var ctx = canvas.getContext('2d');
	ctx.beginPath();
	ctx.fillStyle = color;
	switch(shape){
		case "rect"://矩形の場合
			ctx.fillRect(coords[0],coords[1],coords[2]-coords[0],coords[3]-coords[1]);//(x1,y1,x2,y2)
			break;
		case "circle"://円の場合
			ctx.arc(coords[0],coords[1],coords[2],0,Math.PI*2,false);//(x,y,r,開始角度,終了角度,描画方向)
			break;
		case "poly"://不定形の場合
			ctx.moveTo(coords[0],coords[1]);//最初の点
			for(var i=2;i<coords.length;i=i+2){//(x,y)を繰り返す
				ctx.lineTo(coords[i],coords[i+1]);
			}
			ctx.closePath();
			break;
	}
	ctx.fill();
}
function imgMapToCanvasClear(id){
	var canvas = document.getElementById(id);
	if (!canvas || !canvas.getContext) {return false;}
	var ctx = canvas.getContext('2d');
	var width=$(canvas).attr("width");
	var height=$(canvas).attr("height");
	ctx.clearRect(0,0,width,height); //全カンバス図形消去(0,0,幅,高さ)
}